/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TcpSocketDataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DiagnosticPanel
extends DataInputPanel
implements TableModelListener {
    private static final long serialVersionUID = 81387896121334425L;
    private JButton fSelectAllButton;
    private JButton fDeselectAllButton;
    private JButton fClearButton;
    private JButton fRefreshButton;
    private JTable fDiagnosticTable;
    private int[] fDiagnosticData;
    private String fConnectedIPAddr = null;
    public static final int DIAGNOSTIC_DATA_LENGTH = 4;
    private static final int DIAG_NETWORK_ACCESS_ERR = 6;
    private static final int DIAG_EMBUS = 12;
    private static final int DIAG_SD_RW = 18;
    private static final int DIAG_SD_WPROT = 24;

    public DiagnosticPanel(DataTransfer dt) {
        if (dt != null) {
            this.initialize(dt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataTransfer dt) {
        try {
            this.fDiagnosticData = dt.uploadDiagnosticData();
            if (dt instanceof TcpSocketDataTransfer) {
                this.fConnectedIPAddr = ((TcpSocketDataTransfer)dt).getRemoteAddress();
            }
        }
        catch (TransmissionFailedException tfe) {
        }
        finally {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
        }
        this.setName(Language.getString("extra.transfer.diagnostic.title", "Diagnostic"));
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.fill = 2;
        buttonPanel.add((Component)this.getSelectAllButton(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.fill = 2;
        buttonPanel.add((Component)this.getDeselectAllButton(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.fill = 2;
        buttonPanel.add((Component)this.getClearButton(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.fill = 2;
        buttonPanel.add((Component)this.getRefreshButton(), gbc);
        this.add((Component)buttonPanel, "East");
        this.add((Component)new JScrollPane(this.getDiagnosticTable()), "Center");
        ((DiagnosticTableModel)this.fDiagnosticTable.getModel()).addTableModelListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDiagnosticData() {
        DataTransfer dt = null;
        try {
            dt = this.getDataTransfer();
            this.fDiagnosticData = dt.uploadDiagnosticData();
            if (dt instanceof TcpSocketDataTransfer) {
                this.fConnectedIPAddr = ((TcpSocketDataTransfer)dt).getRemoteAddress();
            }
        }
        catch (TransmissionFailedException tfe) {
        }
        catch (ExceptionAlreadyHandledException exceptionAlreadyHandledException) {
        }
        finally {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
        }
    }

    private DataTransfer getDataTransfer() throws ExceptionAlreadyHandledException {
        DataTransfer dt = this.fConnectedIPAddr == null ? DataTransfer.openConnection(true) : DataTransfer.openConnection("Socket", this.fConnectedIPAddr, true, false);
        return dt;
    }

    private JButton getSelectAllButton() {
        if (this.fSelectAllButton == null) {
            this.fSelectAllButton = new JButton(Language.getString("extra.transfer.diagnostic.selectAll", "Select all"));
            this.fSelectAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DiagnosticTableModel diagMode = (DiagnosticTableModel)DiagnosticPanel.this.fDiagnosticTable.getModel();
                    for (int i = 0; i < diagMode.getRowCount(); ++i) {
                        diagMode.setValueAt(new Boolean(true), i, 2);
                    }
                }
            });
            return this.fSelectAllButton;
        }
        return this.fSelectAllButton;
    }

    private JButton getDeselectAllButton() {
        if (this.fDeselectAllButton == null) {
            this.fDeselectAllButton = new JButton(Language.getString("extra.transfer.diagnostic.deselectAll", "Deselect all"));
            this.fDeselectAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DiagnosticTableModel diagMode = (DiagnosticTableModel)DiagnosticPanel.this.fDiagnosticTable.getModel();
                    for (int i = 0; i < diagMode.getRowCount(); ++i) {
                        diagMode.setValueAt(new Boolean(false), i, 2);
                    }
                }
            });
            this.fDeselectAllButton.setEnabled(false);
            return this.fDeselectAllButton;
        }
        return this.fDeselectAllButton;
    }

    private JButton getRefreshButton() {
        if (this.fRefreshButton == null) {
            this.fRefreshButton = new JButton(Language.getString("extra.transfer.diagnostic.refresh", "Refresh"));
            this.fRefreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DiagnosticPanel.this.readDiagnosticData();
                    DiagnosticTableModel diagMode = (DiagnosticTableModel)DiagnosticPanel.this.getDiagnosticTable().getModel();
                    int i = 0;
                    while (i < diagMode.getRowCount()) {
                        diagMode.removeRow(i);
                    }
                    for (i = 0; i < 32; ++i) {
                        if ((DiagnosticPanel.this.fDiagnosticData[i / 8] & 1 << i % 8) == 0) continue;
                        Vector<Object> rowData = new Vector<Object>();
                        rowData.addElement(String.valueOf(i));
                        rowData.addElement(DiagnosticPanel.this.getErrorText(i));
                        rowData.addElement(new Boolean(false));
                        diagMode.addRow(rowData);
                    }
                    DiagnosticPanel.this.addTableModelListener();
                }
            });
            return this.fRefreshButton;
        }
        return this.fRefreshButton;
    }

    protected void addTableModelListener() {
        ((DiagnosticTableModel)this.fDiagnosticTable.getModel()).addTableModelListener(this);
    }

    private JButton getClearButton() {
        if (this.fClearButton == null) {
            this.fClearButton = new JButton(Language.getString("extra.transfer.diagnostic.clear", "Clear"));
            this.fClearButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    DiagnosticTableModel diagMode = (DiagnosticTableModel)DiagnosticPanel.this.fDiagnosticTable.getModel();
                    int i = 0;
                    while (i < diagMode.getRowCount()) {
                        if (((Boolean)diagMode.getValueAt(i, 2)).booleanValue()) {
                            String indexStr = (String)diagMode.getValueAt(i, 0);
                            int index = Integer.valueOf(indexStr);
                            int[] nArray = DiagnosticPanel.this.fDiagnosticData;
                            int n = index / 8;
                            nArray[n] = nArray[n] & ~(1 << index % 8);
                            diagMode.removeRow(i);
                            continue;
                        }
                        ++i;
                    }
                    DataTransfer dt = null;
                    try {
                        dt = DiagnosticPanel.this.getDataTransfer();
                        dt.sendDiagnosticClearRequest(DiagnosticPanel.this.fDiagnosticData);
                    }
                    catch (ExceptionAlreadyHandledException Ex) {
                    }
                    finally {
                        if (dt != null) {
                            dt.closePort();
                            dt = null;
                        }
                    }
                }
            });
            this.fClearButton.setEnabled(false);
            return this.fClearButton;
        }
        return this.fClearButton;
    }

    private JTable getDiagnosticTable() {
        if (this.fDiagnosticTable == null) {
            Vector<String> columnNames = new Vector<String>();
            Vector data = new Vector();
            columnNames.add(Language.getString("panel.diagnostic.ID", "ID"));
            columnNames.add(Language.getString("panel.diagnostic.errorDescription", "Error description"));
            columnNames.add("");
            for (int i = 0; i < 32; ++i) {
                if ((this.fDiagnosticData[i / 8] & 1 << i % 8) == 0) continue;
                Vector<Object> rowData = new Vector<Object>();
                rowData.addElement(String.valueOf(i));
                rowData.addElement(this.getErrorText(i));
                rowData.addElement(new Boolean(false));
                data.addElement(rowData);
            }
            if (data.isEmpty()) {
                this.getSelectAllButton().setEnabled(false);
            }
            this.fDiagnosticTable = new JTable(new DiagnosticTableModel(data, columnNames));
            this.fDiagnosticTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.fDiagnosticTable.getColumnModel().getColumn(1).setPreferredWidth(400);
            this.fDiagnosticTable.getColumnModel().getColumn(2).setPreferredWidth(5);
            return this.fDiagnosticTable;
        }
        return this.fDiagnosticTable;
    }

    private String getErrorText(int i) {
        String errText = " ";
        switch (i) {
            case 6: {
                errText = Language.getString("panel.diagnostic.networkAccessErr", "Network access err");
                break;
            }
            case 12: {
                errText = Language.getString("panel.diagnostic.emBusErr", "EM bus err");
                break;
            }
            case 18: {
                errText = Language.getString("panel.diagnostic.sdCardRWErr", "SD card r/w err");
                break;
            }
            case 24: {
                errText = Language.getString("panel.diagnostic.sdCardWriteProtectionErr", "SD card write protection");
                break;
            }
        }
        return errText;
    }

    public void tableChanged(TableModelEvent e) {
        boolean isSelected = false;
        boolean isAllSelected = true;
        TableModel model = (TableModel)e.getSource();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Boolean data = (Boolean)model.getValueAt(i, 2);
            if (data.booleanValue()) {
                isSelected = true;
                continue;
            }
            isAllSelected = false;
        }
        if (isSelected) {
            this.fClearButton.setEnabled(true);
            this.fDeselectAllButton.setEnabled(true);
        } else {
            this.fClearButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
        }
        if (isAllSelected) {
            this.fSelectAllButton.setEnabled(false);
        } else {
            this.fSelectAllButton.setEnabled(true);
        }
    }

    private class DiagnosticTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -8828119503484214781L;

        public DiagnosticTableModel(Vector data, Vector columnNames) {
            super(data, columnNames);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }
    }
}

